﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Helper;
using ZSMusic.Model;
using Win32Helper;
namespace  ZSMusic.Winform
{//∧∨
    public partial class FrmMiniPlayer : Form
    {
        public FrmMain MyParent { get; set; }
        public FrmMiniPlayer()
        {
            InitializeComponent();
        }
        private void FrmLrcDesktop_Load(object sender, EventArgs e)
        {
            // lrcView.SelectedIndex = 1;
        }
        private void panTop_MouseDown(object sender, MouseEventArgs e)
        {
            Win32.MoveWindow(this);
        }

        private void btnPause_Click(object sender, EventArgs e)
        {
            MyParent.btnPause_Click(sender, e);
        }
        private void btnPre_Click(object sender, EventArgs e)
        {
            MyParent.btnPre_Click(sender, e);
        }
        private void btnNext_Click(object sender, EventArgs e)
        {
            MyParent.btnNext_Click(sender, e);
        }

        private void FrmMiniPlayer_MouseDown(object sender, MouseEventArgs e)
        {
            Win32.MoveWindow(this);
        }

        private void btnClose_Click(object sender, EventArgs e)
        {
            this.Hide();
        }

        private void chkTop_CheckedChanged(object sender, EventArgs e)
        {
            this.TopMost = chkTop.Checked;
        }

        private void trcDur_MouseUp(object sender, MouseEventArgs e)
        {
            MyParent.player.Ctlcontrols.currentPosition = trcDur.Value;
        }

        private void picSong_MouseDoubleClick(object sender, MouseEventArgs e)
        {

        }

        private void FrmMiniPlayer_VisibleChanged(object sender, EventArgs e)
        {
            MyParent.chk迷你播放器.Checked = this.Visible;
        }

        private void chkLrcView_CheckedChanged(object sender, EventArgs e)
        {
            if (chkLrcView.Checked)
            {
                chkLrcView.Text = "∧";
                this.TransparencyKey = Color.FromArgb(1, 255, 255);
                lrcView.Show();
            }
            else
            {
                chkLrcView.Text = "∨";
                lrcView.Hide();
                this.TransparencyKey = panLrcView.BackColor;
            }
        }

        private void lrcView_MouseDown(object sender, MouseEventArgs e)
        {
            LrcWord l = lrcView.SelectedItem as LrcWord;
            if (l != null)
            {
                MyParent.Duration = l.Time;
            }
        }

        private void lrcView_DrawItem(object sender, DrawItemEventArgs e)
        {
            try
            {
                e.DrawBackground();
                e.DrawFocusRectangle();
                StringFormat strFmt = new System.Drawing.StringFormat();
                strFmt.Alignment = StringAlignment.Center; //文本垂直居中
                strFmt.LineAlignment = StringAlignment.Center; //文本水平居中
                e.Graphics.DrawString(lrcView.Items[e.Index].ToString(), e.Font, new SolidBrush(e.ForeColor), e.Bounds, strFmt);
            }
            catch (Exception)
            { }
        }

        private void picSong_Click(object sender, EventArgs e)
        {
            MyParent.显示隐藏主界面ToolStripMenuItem_Click(sender, e);
        }

        private void btnPlayMenu_MouseUp(object sender, MouseEventArgs e)
        {
            MyParent.menuPlay.Show(btnPlayMenu, e.Location);
        }

        private void btnLove_Click(object sender, EventArgs e)
        {
            MyParent.btnLove_Click(sender, e);
        }

        private void btnRefresh_Click(object sender, EventArgs e)
        {
            MyParent.刷新toolStripMenuItem_Click(null, null);
        }

        private void btnPlayMode_MouseUp(object sender, MouseEventArgs e)
        {
            MyParent.menuPlayMode_Opening(null, null);
            MyParent.menuPlayMode.Show(btnPlayMode, e.Location);
        }
    }
}
